<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use EshopCatalog\Model\Entities\Category;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_gifts__category_gift")
 * @ORM\Entity
 */
class CategoryGift
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Gift")
	 * @ORM\JoinColumn(name="gift_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Gift $gift;

	/**
	 * @var Collection<Category>
	 * @ORM\ManyToMany(targetEntity="EshopCatalog\Model\Entities\Category")
	 * @ORM\JoinTable(name="eshop_gifts__category_gifts",
	 *     joinColumns={@ORM\JoinColumn(name="gift_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")})
	 */
	protected Collection $categories;

	/**
	 * @var double|null
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $priceFrom;

	/**
	 * @var double|null
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $priceTo;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $dateFrom;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $dateTo;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", length=1, options={"default": 1})
	 */
	protected $isActive;

	public function __construct(Gift $gift)
	{
		$this->setGift($gift);
		$this->categories = new ArrayCollection;
		$this->isActive   = 1;
	}

	public function getGift(): Gift { return $this->gift; }

	public function setGift(Gift $gift): self
	{
		$this->gift = $gift;

		return $this;
	}

	public function isActive(): int { return (int) $this->isActive; }

	/**
	 * @param int|bool $active
	 */
	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

	/**
	 * @return Collection<Category>
	 */
	public function getCategories() { return $this->categories; }

	/**
	 * @param Category[] $categories
	 */
	public function setCategories(array $categories): self
	{
		$this->categories = new ArrayCollection($categories);

		return $this;
	}
}
