<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Core\Model\Helpers\Traits\TExtraField;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_gifts__gift")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class Gift
{
	use TId;
	use TTranslateListener;
	use TExtraField;

	public const EXTRA_FIELD_SECTION = 'eshopGiftsGift';

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @var Collection<string, GiftText>
	 * @ORM\OneToMany(targetEntity="GiftText", mappedBy="gift", indexBy="lang", cascade={"all"})
	 */
	protected $texts;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", length=1, options={"default": 1})
	 */
	public $isActive;

	public function __construct(Product $product)
	{
		$this->setProduct($product);
		$this->texts    = new ArrayCollection;
		$this->isActive = 1;
	}

	public function getProduct(): Product { return $this->product; }

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function isActive(): int { return (int) $this->isActive; }

	/**
	 * @param int|bool $active
	 */
	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

	/**
	 * @return Collection<string, GiftText>
	 */
	public function getTexts() { return $this->texts; }

	public function getText(?string $lang = null): ?GiftText
	{
		return $this->texts->get($lang ?? $this->locale) ?? null;
	}

	/**
	 * @param GiftText[] $texts
	 */
	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}
}
