<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Core\Model\Helpers\Traits\TExtraField;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_gifts__gift_text")
 * @ORM\Entity
 */
class GiftText
{
	use TExtraField;

	public const EXTRA_FIELD_SECTION = 'eshopGiftsGiftText';

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Gift", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="gift_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Gift $gift;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=false)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $description = null;

	public function __construct(Gift $gift, string $lang)
	{
		$this->gift = $gift;
		$this->lang = $lang;
	}

	public function getGift(): Gift { return $this->gift; }

	public function getLang(): string { return $this->lang; }
}
