<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use EshopOrders\Model\Entities\GroupCustomers;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_gifts__order_gift")
 * @ORM\Entity
 */
class OrderGift
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Gift")
	 * @ORM\JoinColumn(name="gift_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Gift $gift;

	/**
	 * @var Collection<string, Site>
	 * @ORM\ManyToMany(targetEntity="Core\Model\Entities\Site", indexBy="ident")
	 * @ORM\JoinTable(name="eshop_gifts__order_gifts",
	 *     joinColumns={@ORM\JoinColumn(name="gift_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="site_id", referencedColumnName="ident", onDelete="CASCADE")})
	 */
	protected Collection $sites;

	/**
	 * @var Collection<GroupCustomers>
	 * @ORM\ManyToMany(targetEntity="EshopOrders\Model\Entities\GroupCustomers", indexBy="id")
	 * @ORM\JoinTable(name="eshop_gifts__order_gift_customer_group",
	 *     joinColumns={@ORM\JoinColumn(name="og_id", referencedColumnName="id", onDelete="CASCADE")},
	 *     inverseJoinColumns={@ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")}
	 *     )
	 */
	public Collection $customerGroups;

	/**
	 * @ORM\Column(type="smallint", length=1, options={"default": 0, "unsigned": true})
	 */
	public int $withoutCustomerGroup = 0;

	/**
	 * @var double|null
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $priceFrom;

	/**
	 * @var double|null
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $priceTo;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $dateFrom;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $dateTo;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", length=1, options={"default": 1})
	 */
	public $isActive;

	public function __construct(Gift $gift)
	{
		$this->setGift($gift);
		$this->isActive = 1;
		$this->sites             = new ArrayCollection;
		$this->customerGroups    = new ArrayCollection;
	}

	public function getGift(): Gift { return $this->gift; }

	public function setGift(Gift $gift): self
	{
		$this->gift = $gift;

		return $this;
	}

	public function isActive(): int { return (int) $this->isActive; }

	/**
	 * @param bool|int $active
	 */
	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

	/**
	 * @return Collection<string, Site>
	 */
	public function getSites() { return $this->sites; }

	public function setSites(array $sites): self
	{
		foreach (array_diff($this->sites->getKeys(), array_keys($sites)) as $v) {
			$this->sites->remove($v);
		}

		foreach (array_diff(array_keys($sites), $this->sites->getKeys()) as $v) {
			$this->sites->add($sites[$v]);
		}

		return $this;
	}

	/**
	 * @return Collection<int, GroupCustomers>
	 */
	public function getCustomerGroups() { return $this->customerGroups; }

	public function setCustomerGroups(array $groups): self
	{
		foreach (array_diff($this->customerGroups->getKeys(), array_keys($groups)) as $v) {
			$this->customerGroups->remove($v);
		}

		foreach (array_diff(array_keys($groups), $this->customerGroups->getKeys()) as $v) {
			$this->customerGroups->add($groups[$v]);
		}

		return $this;
	}
}
