<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_gifts__product_gift")
 * @ORM\Entity
 */
class ProductGift
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Gift")
	 * @ORM\JoinColumn(name="gift_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Gift $gift;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $dateFrom;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $dateTo;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", length=1, options={"default": 1})
	 */
	public $isActive;

	public function __construct(Gift $gift, Product $product)
	{
		$this->setGift($gift);
		$this->product  = $product;
		$this->isActive = 1;
	}

	public function getGift(): Gift { return $this->gift; }

	public function setGift(Gift $gift): self
	{
		$this->gift = $gift;

		return $this;
	}

	public function getProduct(): Product { return $this->product; }

	public function isActive(): int { return (int) $this->isActive; }

	/**
	 * @param bool|int $active
	 */
	public function setActive($active): self
	{
		$this->isActive = (int) $active;

		return $this;
	}

}
