<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopGifts\Model\Entities\Gift;
use Nette\Caching\Cache;
use Override;

/**
 * @method Gift|null getReference($id)
 * @method Gift|null get($id)
 */
class Gifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = Gift::class;

	public function __construct(
		protected Translator   $translator,
		protected CacheService $cacheService,
	)
	{
	}

	/** @return Gift[] */
	#[Override]
	public function getAll()
	{
		/** @var Gift[] */
		return $this->getEr()->createQueryBuilder('g')
			->addSelect('gt')
			->innerJoin('g.texts', 'gt')
			->getQuery()->getResult();
	}

	/**
	 * @param int|string $id
	 *
	 * @return bool
	 */
	#[Override]
	public function remove($id)
	{
		$result = parent::remove($id);

		if ($result) {
			$this->cacheService->defaultCache->remove('categoryGiftsAll');
			$this->cacheService->defaultCache->clean([
				Cache::Tags => 'gifts',
			]);
		}

		return $result;
	}
}
