<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Query\Parameter;
use EshopGifts\Model\Entities\OrderGift;
use Override;

/**
 * @method OrderGift|null getReference($id)
 * @method OrderGift[] getAll()
 */
class OrderGifts extends BaseEntityService
{
	use TActive;

	protected $entityClass = OrderGift::class;

	public function __construct(
		protected Translator $translator,
	)
	{
	}

	/**
	 * @param int|string $id
	 *
	 * @throws NonUniqueResultException
	 */
	#[Override]
	public function get($id): ?OrderGift
	{
		/** @var OrderGift|null */
		return $this->getEr()->createQueryBuilder('og')
			->addSelect('gift')
			->where('og.id = :id')
			->innerJoin('og.gift', 'gift')
			->setParameters(new ArrayCollection([new Parameter('id', $id)]))->getQuery()->getOneOrNullResult();
	}
}
