<?php declare(strict_types = 1);

namespace EshopGifts\AdminModule\Presenters;

use Nette\Application\BadRequestException;
use Nette\Application\UI\ComponentReflection;
use Override;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/**
	 * @param ComponentReflection $element
	 *
	 * @throws BadRequestException
	 */
	#[Override]
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}
}
