<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class Gift
{
	public ?string $code1     = null;
	public ?string $ean       = null;
	public ?string $addOrigin = null;

	public function __construct(
		protected int     $id,
		protected Product $product,
		protected ?string $name = null,
		protected ?string $description = null,
	)
	{
		$this->name        = $name ?: $product->getName();
		$this->description = $description ?: $product->shortDescription;
	}

	public function getId(): int { return $this->id; }

	public function getProduct(): Product { return $this->product; }

	public function getName(): ?string { return $this->name; }

	public function getDescription(): ?string { return $this->description; }
}
