<?php declare(strict_types = 1);

namespace EshopGifts\FrontModule\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\NonUniqueResultException;
use EshopGifts\Model\Entities\ProductGift;
use Nette\Application\UI\InvalidLinkException;
use Nette\Utils\DateTime;
use Throwable;

class ProductGifts extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = ProductGift::class;

	/** @var int[][]|null */
	protected ?array $cGifts = null;

	public function __construct(
		protected Gifts $giftsService,
	)
	{
	}

	/**
	 *
	 * @return Dao\Gift[]
	 * @throws NonUniqueResultException
	 * @throws InvalidLinkException
	 * @throws Throwable
	 */
	public function findGifts(int $productId): array
	{
		$giftIds = $this->getAll()[$productId] ?? null;
		$result  = [];

		foreach ($giftIds ? $this->giftsService->getByIds($giftIds) : [] as $gift) {
			$gift->addOrigin        = 'product';
			$result[$gift->getId()] = $gift;
		}

		return $result;
	}

	public function getAll(): array
	{
		if ($this->cGifts === null) {
			$this->cGifts = [];
			$today        = (new DateTime())->setTime(0, 0, 0);
			foreach ($this->getEr()->createQueryBuilder('pg')
				         ->select('IDENTITY(pg.gift) as gift, IDENTITY(pg.product) as product')
				         ->where('pg.dateFrom <= :today OR pg.dateFrom IS NULL')
				         ->andWhere('pg.dateTo >= :today OR pg.dateTo IS NULL')
				         ->andWhere('pg.isActive = 1')
				         ->setParameters(new ArrayCollection([new Parameter('today', $today)]))
				         ->getQuery()->getScalarResult() as $row) {
				/** @var array $row */
				$this->cGifts[$row['product']][] = (int) $row['gift'];
			}
		}

		return $this->cGifts;
	}
}
