<?php declare(strict_types = 1);

namespace EshopGifts\Model\Entities;

use Core\Model\Helpers\Traits\TExtraField;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_gifts__gift_text')]
#[ORM\Entity]
class GiftText
{
	use TExtraField;

	public const EXTRA_FIELD_SECTION = 'eshopGiftsGiftText';

	#[ORM\JoinColumn(name: 'gift_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Gift::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	protected Gift $gift;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	private string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $name = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $description = null;

	public function __construct(Gift $gift, string $lang)
	{
		$this->gift = $gift;
		$this->lang = $lang;
	}

	public function getGift(): Gift { return $this->gift; }

	public function getLang(): string { return $this->lang; }
}
