<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Customer;

use Core\Model\UI\BaseControl;
use EshopOrders\AdminModule\Model\Customers;
use EshopOrders\Model\Entities\GroupCustomers;

class CustomersGrid extends BaseControl
{
	/** var Customers */
	protected $customersService;
	
	public function __construct(Customers $customers)
	{
		$this->customersService = $customers;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		
		$qb = $this->customersService->getEr()->createQueryBuilder('p');
		$grid->setDataSource($qb);
		
		//Columns
		$grid->addColumnLink('name', 'default.firstName', 'Customers:editCustomer', 'user.name');
		$grid->addColumnLink('lastname', 'default.lastName', 'Customers:editCustomer', 'user.lastname');
		$grid->addColumnText('email', 'default.email', 'user.email');
		$grid->addColumnText('phone', 'default.phone');
		//$grid->addColumnText('street', 'default.street', 'addressDelivery:street');
		//$grid->addColumnText('city', 'default.city', 'addressDelivery:city');
		//$grid->addColumnText('postal', 'default.zipNumber', 'addressDelivery:postal');
		$grid->addColumnStatus('isActive', 'default.isActive', 'user.isActive')->setAlign('center')
			->addOption(1, 'eshopOrders.defaultGrid.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'eshopOrders.defaultGrid.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];
		
		// Filter
		
		// Actions
		$grid->addAction('edit', '', 'Customers:editCustomer')->setIcon('edit')->setBsType('primary');

		$groupCustomers[0] = $this->translator->translate('eshopOrders.defaultGrid.nullGroupCustomers');
		foreach ($this->em->getRepository(GroupCustomers::class)->createQueryBuilder('gc')
			         ->select('gc.id, gc.name')->getQuery()->getArrayResult() as $gc)
			$groupCustomers[$gc['id']] = $gc['name'];

		$grid->addGroupSelectAction('eshopOrders.defaultGrid.editGroupCustomers', $groupCustomers)
			->onSelect[] = [$this, 'gridEditGroupCustomers'];
		
		// Columns prototype
		
		return $grid;
	}
	

	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
	
	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();
		
		if($this->customersService->isAdmin($id)) {
			$presenter->flashMessageWarning('eshopOrders.customerForm.noAdminDeactivate');
		} else {
			if ($this->customersService->setPublish($id, $newStatus)) {
				$presenter->flashMessageSuccess('eshopOrders.defaultGrid.publishChanged');
			} else {
				$presenter->flashMessageDanger('eshopOrders.defaultGrid.publishChangeFailed');
			}
		}
		
		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/**
	 * @param array  $ids
	 * @param string $groupcustomers
	 */
	public function gridEditGroupCustomers(array $ids, $groupCustomers)
	{
		$presenter = $this->getPresenter();
		if ($this->customersService->setGroupCustomers($ids, $groupCustomers)) {
			$presenter->flashMessageSuccess('eshopOrders.defaultGrid.groupCustomersChanged');
		} else {
			$presenter->flashMessageDanger('eshopOrders.defaultGrid.groupCustomersChangeFailed');
		}

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
	
}
