<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Payment;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Payments;

class PaymentsGrid extends BaseControl
{
	/** var Payments */
	protected $paymentsService;
	
	public function __construct(Payments $payments)
	{
		$this->paymentsService = $payments;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		
		$qb = $this->paymentsService->getEr()->createQueryBuilder('p')->orderBy('p.position', 'ASC');
		$grid->setDataSource($qb);
		
		$grid->setSortable();
		$grid->setSortableHandler('paymentsGrid:gridSortableRow!');
		
		//Columns
		$grid->addColumnLink('name', 'default.name', 'PaymentSpedition:editPayment');
		$grid->addColumnText('ident', 'eshopOrders.paymentForm.itemIdent');
		$grid->addColumnStatus('isPublished', 'default.isActive')->setAlign('center')
			->addOption(1, 'eshopOrders.defaultGrid.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'eshopOrders.defaultGrid.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];
		$grid->addColumnNumber('price', 'eshopOrders.default.priceSimple');
		$grid->addColumnNumber('availableFrom', 'eshopOrders.default.availableFromSimple');
		$grid->addColumnNumber('availableTo', 'eshopOrders.default.availableToSimple');
		
		// Filter
		
		// Actions
		$grid->addAction('edit', '', 'PaymentSpedition:editPayment')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');
		
		// Columns prototype
		
		return $grid;
	}
	

	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	
	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->paymentsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');
		
		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
	

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
	
	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);
		
		if ($id != null && $position != null && $this->paymentsService->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}
		
		$presenter->redrawControl('flashes');
		$presenter->redrawControl('paymentsGrid');
		$presenter->redrawControl('paymentSpeditionsGrid');
	}
	
	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();
		
		if ($this->paymentsService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('eshopOrders.defaultGrid.publishChanged');
		else
			$presenter->flashMessageDanger('eshopOrders.defaultGrid.publishChangeFailed');
		
		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
	
}
