<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\Event\ComponentTemplateEvent;
use EshopOrders\FrontModule\Components\Discount\DiscountForm;
use Nette\Http\Session;
use Nette\Http\SessionSection;
use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Components\Discount\IDiscountFormFactory;
use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\CartHelper;

class CartDetail extends BaseControl
{
	/** @var CartHelper */
	protected $cartHelperService;

	/** @var Session */
	protected $session;

	/** @var Carts */
	private $cartsService;

	/** @var ICartDetailItemFactory */
	private $cartDetailItemFactory;

	/** @var IDiscountFormFactory */
	protected $discountFormFactory;

	/** @var SessionSection */
	protected $sessionSection;

	/** @var Cart */
	private $cart;

	public function __construct(Carts $carts, ICartDetailItemFactory $factory, IDiscountFormFactory $discountFormFactory, CartHelper $cartHelper, Session $session)
	{
		$this->cartsService          = $carts;
		$this->cartDetailItemFactory = $factory;
		$this->discountFormFactory   = $discountFormFactory;
		$this->cartHelperService     = $cartHelper;

		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}

	/**
	 * Zobrazení položek objednávky na stránce s objednávkou
	 */
	public function render(): void
	{
		$this->template->setFile($this->getTemplateFile());

		$cart                           = $this->getCart();
		$this->template->cart           = $cart;
		$this->template->cartItems      = $cart->cartItems;
		$this->template->cartItemsPrice = $cart->getPriceTotal();

		$freeSped                               = $this->cartHelperService->countFreeSpedition();
		$this->template->freeSpeditionPrice     = $freeSped['minPrice'];
		$this->template->freeSpeditionRemaining = $freeSped['remaining'];

		$cart           = $this->cartsService->getCurrentCart();
		$discountCoupon = $this->cartHelperService->getDiscountCoupon($cart->getPriceTotal());
		if ($discountCoupon) {
			$this->template->discountCoupon = $discountCoupon;
		}

		$this->eventDispatcher->dispatch('eshopOrders.cartDetail.render', new ComponentTemplateEvent($this->template, $this));

		$this->template->render();
	}

	protected function getCart(): Cart
	{
		if (!$this->cart) {
			$this->cart = $this->cartsService->getCurrentCart();
		}

		return $this->cart;
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentCartDetailItem(): CartDetailItem
	{
		$control = $this->cartDetailItemFactory->create();

		return $control;
	}

	protected function createComponentDiscountForm(): DiscountForm
	{
		$control = $this->discountFormFactory->create();

		return $control;
	}
}

