<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Customer;

use Core\Model\UI\BaseControl;
use Doctrine\Common\Collections\ArrayCollection;
use EshopOrders\FrontModule\Model\Customers;
use EshopOrders\Model\Orders;

class OrdersList extends BaseControl
{
	/** @var Orders */
	private $ordersService;
	
	/** @var Customers */
	private $customersService;

	public function __construct(Orders $orders, Customers $customers)
	{
		$this->ordersService    = $orders;
		$this->customersService = $customers;
	}
	
	/** seznam vsech objednavek zakaznika */
	public function render()
	{
		$this->template->setFile($this->getTemplateFile());
		
		$userId = $this->getPresenter()->getUser()->id;
		$customer = $this->customersService->getByUserId($userId);
		if($customer) {
			$orders                 = $this->ordersService->getByCustomer($customer);
			$this->template->orders = $orders;
		} else {
			$this->template->orders = new ArrayCollection();
		}
		
		$this->template->render();
	}
}

