<?php declare(strict_types=1);

namespace EshopOrders\FrontModule\Components\Order;

use Nette\Http\Session;
use Nette\Http\SessionSection;
use Core\Model\UI\BaseControl;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Entities\OrderFlag;

class OrderTracking extends BaseControl
{
	
	/** @var Orders */
	protected $ordersService;
	
	/** @var Order */
	public $order;
	
	/** @var SessionSection */
	protected $sessionSection;
	
	/** @var [] */
	protected $zboziCzConfig;
	
	public function __construct($data, Orders $orders, Session $session)
	{
		$this->zboziCzConfig = $data['zboziCzConfig'];
		
		$this->ordersService = $orders;
		
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}
	
	/**
	 * Sledovani objednavky pro Google Tag Manager
	 */
	public function render()
	{
		$this->template->setFile($this->getTemplateFile());
		if($this->sessionSection->trackConversion) {
			$this->template->order = $this->order;
			$this->template->hasAgreedQuestioning = (int)$this->order->hasFlag(OrderFlag::TYPE_QUESTIONING);
			$this->template->zboziStoreKey = $this->zboziCzConfig['shopId'];
			$this->template->zboziUseSandbox = $this->zboziCzConfig['isSandbox'];
			unset($this->sessionSection->trackConversion);
		}
		$this->template->render();
	}
	
	public function setOrder($ident)
	{
		$this->order = $this->ordersService->getByIdent($ident);
	}
}
