<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Spedition
{
	use MagicAccessors;
	
	/** @var int */
	public $id;
	
	/**
	 * @var string
	 */
	protected $name;
	
	/**
	 * @var string
	 */
	protected $ident;
	
	/**
	 * @var string
	 */
	protected $text;
	
	/**
	 * @var int
	 */
	protected $isPublished;
	
	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 */
	protected $position;
	
	/**
	 * @var int
	 */
	protected $price;
	
	/**
	 * @var int
	 */
	protected $freeFrom;
	
	/**
	 * @var int
	 */
	protected $availableFrom;
	
	/**
	 * @var int
	 */
	protected $availableTo;
	
	/**
	 * @var string
	 */
	public $image;
	
	/*******
	 * === ID
	 */
	
	public function getId(): int
	{
		return $this->id;
	}
	
	public function setId(int $id): Spedition
	{
		$this->id = $id;
		return $this;
	}
	
	/*******
	 * === Ident
	 */
	
	public function getIdent()
	{
		return $this->ident;
	}
	
	public function setIdent($ident): Spedition
	{
		$this->ident = $ident;
		return $this;
	}
	
	/*******
	 * === Name
	 */
	
	public function getName(): string
	{
		return $this->name;
	}
	
	public function setName(string $name): Spedition
	{
		$this->name = $name;
		return $this;
	}
	
	/*******
	 * === Text
	 */
	
	public function getText(): string
	{
		return $this->text;
	}
	
	public function setText(string $text): Spedition
	{
		$this->text = $text;
		return $this;
	}
	
	/*******
	 * === IsPublished
	 */
	
	public function isPublished()
	{
		return $this->isPublished;
	}
	
	public function setPublished($isPublished): Spedition
	{
		$this->isPublished = $isPublished;
		return $this;
	}
	
	/*******
	 * === Position
	 */
	
	public function getPosition(): int
	{
		return $this->position;
	}
	
	public function setPosition(int $position): Spedition
	{
		$this->position = $position;
		return $this;
	}
	
	/*******
	 * === Price
	 */
	
	public function getPrice(): int
	{
		return $this->price;
	}
	
	public function setPrice(int $price): Spedition
	{
		$this->price = $price;
		return $this;
	}
	
	/**
	 * vrati cenu podle kosiku:
	 *  - podle celkove ceny objednavky muze byt doprava zdarma
	 *  - kdyz je v kosiku produkt se stitkem "doprava zdarma"
	 * @param $cartValue celkova hodnota zbozi v kosiku
	 * @return int
	 */
	public function getPriceActual(Cart $cart)
	{
		$price = $this->price;
		if($this->getFreeFrom() <= $cart->getPriceTotal()) {
			$price = 0;
		}
		foreach ($cart->getCartItems() as $item) {
			if($item->freeDelivery === true) {
				$price = 0;
				break;
			}
		}
		return $price;
	}
	
	/*******
	 * === FreeFrom
	 */
	
	public function getFreeFrom(): int
	{
		return $this->freeFrom;
	}
	
	public function setFreeFrom(int $freeFrom): Spedition
	{
		$this->freeFrom = $freeFrom;
		return $this;
	}
	
	/*******
	 * === AvailableFrom
	 */
	
	public function getAvailableFrom()
	{
		return $this->availableFrom;
	}
	
	public function setAvailableFrom($availableFrom): Spedition
	{
		$this->availableFrom = $availableFrom;
		return $this;
	}
	
	/*******
	 * === AvailableTo
	 */
	
	public function getAvailableTo()
	{
		return $this->availableTo;
	}
	
	public function setAvailableTo($availableTo): Spedition
	{
		$this->availableTo = $availableTo;
		return $this;
	}
	
	/*******
	 * === FreeFrom
	 */
	
	public function getImage()
	{
		return $this->image;
	}
	
	public function setImage($image): Spedition
	{
		$this->image = $image;
		return $this;
	}
	
}


