<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopOrders\FrontModule\Components\Order\IOrderTrackingFactory;
use EshopOrders\Model\Orders;
use EshopOrders\FrontModule\Model\Carts;

class PaymentPresenter extends BasePresenter
{
	/** @var Orders */
	protected $ordersService;

	public function __construct(Orders $orders)
	{
		$this->ordersService = $orders;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	
	public function renderPaymentFinished()
	{
		if($this->getParameter('orderIdent')) {
			$order = $this->ordersService->getByIdent($this->getParameter('orderIdent'));
			$this->template->order = $order;
		}
		
		//flash zpravy zobrazime v textu, ne jako prekryvne
		$this->template->messages = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
	
	protected function createComponentOrderTracking(IOrderTrackingFactory $factory)
	{
		$control = $factory->create();
		if($this->getParameter('orderIdent')) {
			$control->setOrder($this->getParameter('orderIdent'));
		}
		return $control;
	}
}
