<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\UI\BaseControl;
use Nette\Utils\ArrayHash;
use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\AddedCartItem;
use Kdyby\Events\EventManager;
use Kdyby\Events\EventArgsList;

class CartPreview extends BaseControl
{
	/** @var Carts */
	private $cartsService;

	/** @var Cart */
	private $cart;

	/** @var EventManager */
	public $eventManager;

	public function __construct(Carts $carts, EventManager $eventManager)
	{
		$this->cartsService = $carts;
		$this->eventManager = $eventManager;
	}

	//zobrazeni info o kosiku (pocet polozek a cena) v hlavicce
	public function render()
	{
		$this->template->setFile($this->getTemplateFile());
		$cart = $this->getCart();
		$this->template->itemsCount = $cart->getItemsCount();
		$this->template->itemsPrice = $cart->getPriceTotal();
		$this->template->render();
	}
	
	public function renderMobile()
	{
		$this->template->isMobile = true;
		$this->render();
	}

	protected function getCart()
	{
		if (!$this->cart) {
			$this->cart = $this->cartsService->getCurrentCart();
		}

		return $this->cart;
	}

	/*******************************************************************************************************************
	 * ============================== Signals
	 */

}

