<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\Event\ComponentTemplateEvent;
use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\Cart;

class OrderCartDetail extends BaseControl
{
	/** @var Carts */
	private $cartsService;

	/** @var Cart */
	private $cart;

	public function __construct(Carts $carts)
	{
		$this->cartsService = $carts;
	}

	/**
	 * zobrazeni kosiku na kazdem kroku objednavky
	 *
	 * @param array|null $discountCoupon
	 */
	public function render($discountCoupon = null): void
	{
		$this->template->setFile($this->getTemplateFile());

		$cart                           = $this->getCart();
		$this->template->cart           = $cart;
		$this->template->cartItems      = $cart->cartItems;
		$this->template->cartItemsPrice = $cart->getPriceTotal();

		if ($discountCoupon)
			$this->template->discountCoupon = $discountCoupon;

		$this->eventDispatcher->dispatch('eshopOrders.orderCartDetail.render', new ComponentTemplateEvent($this->template, $this));

		$this->template->render();
	}

	//zobrazeni polozek v kosiku na strance s objednavkou
	public function renderSummary(): void
	{
		$this->template->setFile($this->getTemplateFile('CartDetailSummary', 'Order'));

		$cart                           = $this->getCart();
		$this->template->cartItems      = $cart->cartItems;
		$this->template->cartItemsPrice = $cart->getPriceTotal();

		$this->eventDispatcher->dispatch('eshopOrders.orderCartDetail.renderSummary', new ComponentTemplateEvent($this->template, $this));

		$this->template->render();
	}

	protected function getCart(): Cart
	{
		if ($this->cart === null)
			$this->cart = $this->cartsService->getCurrentCart();

		return $this->cart;
	}
}

