<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopOrders\Model\Entities\OrderDiscount;
use Kdyby\Doctrine\Entities\MagicAccessors;

class Discount
{
	use MagicAccessors;

	/** @var string */
	public $id;

	/** @var string */
	public $title;

	/** @var float */
	public $amount;

	/** @var float */
	public $discount;

	/** @var string */
	public $type;

	/** @var string */
	public $typeSymbol;

	public function __construct(string $id, float $amount, string $type)
	{
		$this->id     = $id;
		$this->amount = $amount;
		$this->type   = $type;
	}

	public function calculateDiscount(float $price): float
	{
		if ($this->type == OrderDiscount::TYPE_PERCENT)
			$this->discount = -($price * ((float) $this->amount / 100));
		else
			$this->discount = -((float) $this->amount);

		return $this->discount;
	}
}



