<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Components\Order\IOrderTrackingFactory;

class FinishedPresenter extends BasePresenter
{
	/** @persistent */
	public $orderIdent;

	/** @var Orders */
	protected $ordersService;

	/** @var Order */
	protected $order;

	public function __construct(Orders $orders)
	{
		$this->ordersService = $orders;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionOrderFinished()
	{
		if ($this->getParameter('orderIdent')) {
			$this->order = $this->ordersService->getByIdent($this->getParameter('orderIdent'));
		}
	}

	/*******************************************************************************************************************
	 * ============================== Renders
	 */

	public function renderOrderFinished()
	{
		if ($this->order) {
			$this->template->order = $this->order;
		}

		//flash zpravy zobrazime v textu, ne jako prekryvne
		$paymentType                      = $this->order ? $this->order->getPayment()->getPayment()->getIdent() : null;
		$this->template->paymentType      = $paymentType;
		$this->template->useOrderTracking = $this->order && !in_array($paymentType, ['card', 'essox']);
		$this->template->messages         = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes     = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderTracking(IOrderTrackingFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('orderIdent')) {
			$control->setOrder($this->getParameter('orderIdent'));
		}

		return $control;
	}
}
