<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__order_item_texts")
 * @ORM\Entity
 */
class OrderItemTexts
{
	use MagicAccessors;
	
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="OrderItem", inversedBy="OrderItemTexts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $id;
	
	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	protected $lang;
	
	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	protected $name;
	
	/**
	 * @var string
	 * @ORM\Column(name="variant_name", type="string", length=255)
	 */
	protected $variantName;
	
	public function __construct($id, $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}
	
	public function getLang()
	{
		return $this->lang;
	}
	
	
	/*****
	 * === Name
	 */
	
	public function getName(): string
	{
		return $this->name;
	}
	
	public function setName(string $name): OrderItemTexts
	{
		$this->name = $name;
		return $this;
	}
	
	/*****
	 * === VariantName
	 */
	
	public function getVariantName(): string
	{
		return $this->variantName;
	}
	
	public function setVariantName(string $name): OrderItemTexts
	{
		$this->variantName = $name;
		return $this;
	}
	
}

