<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\PaymentSpedition;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopOrders\Model\Entities\Spedition;
use EshopOrders\Model\Entities\Payment;
use EshopOrders\Model\Entities\PaymentSpedition;
use EshopOrders\AdminModule\Model\Speditions;
use EshopOrders\Model\Payments;
use EshopOrders\Model\PaymentSpeditions;

class PaymentSpeditionForm extends BaseControl
{
	/** @var PaymentSpeditions */
	protected $paymentSpeditionsService;
	
	/** @var PaymentSpedition */
	public $paymentSpedition;

	/** @var Speditions */
	protected $speditionsService;
	
	/** @var Payments */
	protected $paymentsService;
	
	public function __construct(PaymentSpeditions $paymentSpeditions, Speditions $speditions, Payments $payments)
	{
		$this->paymentSpeditionsService = $paymentSpeditions;
		$this->speditionsService        = $speditions;
		$this->paymentsService          = $payments;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();
		
		$paymentChoices = $speditionChoices = [];
		$speditions = $this->speditionsService->getAll();
		$payments = $this->paymentsService->getAll();
		foreach($speditions as $s) {
			$speditionChoices[$s->getId()] = $s->getName() .' - '. $s->getPrice() . ' Kč';
		}
		foreach($payments as $p) {
			$paymentChoices[$p->getId()] = $p->getName() .' - '. $p->getPrice() . ' Kč';
		}
		$form->addSelect('spedition', 'eshopOrders.orderPage.spedition', $speditionChoices)->setRequired();
		$form->addSelect('payment', 'eshopOrders.orderPage.payment', $paymentChoices)->setRequired();
		
		$form->addBool('isPublished', 'default.isActive')->setDefaultValue(1);
		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->paymentSpedition) {
				$paymentSpedition       = $this->paymentSpedition;
				$flashMessage = 'eshopOrders.paymentSpeditionForm.edited';
			} else {
				$paymentSpedition       = new PaymentSpedition();
				$flashMessage = 'eshopOrders.paymentSpeditionForm.added';
			}
			
			$paymentSpedition->setPayment($this->paymentsService->get($values->payment));
			$paymentSpedition->setSpedition($this->speditionsService->get($values->spedition));
			$paymentSpedition->isPublished = $values->isPublished;
			
			$this->em->persist($paymentSpedition)->flush();
			$form->addCustomData('paymentSpeditionId', $paymentSpedition->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			
			return false;
		}
	}

	public function setPaymentSpedition($id)
	{
		$this->paymentSpedition = $this->paymentSpeditionsService->get($id);
		
		if ($this->paymentSpedition) {
			$m = $this->paymentSpedition;
			$this['form']->setDefaults([
				'payment'		=> $m->getPayment()->getId(),
				'spedition'		=> $m->getSpedition()->getId(),
				'isPublished'   => $m->isPublished,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
