<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Nette\Http\IResponse;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Components\Payment\IPaymentFormFactory;
use EshopOrders\AdminModule\Components\Payment\IPaymentsGridFactory;
use EshopOrders\AdminModule\Components\Spedition\ISpeditionFormFactory;
use EshopOrders\AdminModule\Components\Spedition\ISpeditionsGridFactory;
use EshopOrders\AdminModule\Components\PaymentSpedition\IPaymentSpeditionFormFactory;
use EshopOrders\AdminModule\Components\PaymentSpedition\IPaymentSpeditionsGridFactory;
use EshopOrders\Model\Entities\Payment;
use EshopOrders\Model\Entities\Spedition;
use EshopOrders\Model\Entities\PaymentSpedition;

class PaymentSpeditionPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('eshopOrders.menu.paymentSpedition'));
		$this->setHeader('eshopOrders.menu.paymentSpedition', 'fa fa-truck');
	}
	
	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	
	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopOrders.menu.addPayment',
				'link'  => 'PaymentSpedition:addPayment',
				'ico'   => 'plus',
			], [
				'title' => 'eshopOrders.menu.addSpedition',
				'link'  => 'PaymentSpedition:addSpedition',
				'ico'   => 'plus',
			], [
				'title' => 'eshopOrders.menu.addPaymentSpedition',
				'link'  => 'PaymentSpedition:addPaymentSpedition',
				'ico'   => 'plus',
			]
		]]);
	}

	public function actionAddPayment()
	{
		$this->setTitle($this->translator->translate('eshopOrders.menu.addPayment'));
		$this->setHeader('eshopOrders.menu.addPayment','fa fa-credit-card');
	}

	public function actionAddSpedition()
	{
		$this->setTitle($this->translator->translate('eshopOrders.menu.addSpedition'));
		$this->setHeader('eshopOrders.menu.addSpedition','fa fa-truck');
	}
	
	public function actionAddPaymentSpedition()
	{
		$this->setTitle($this->translator->translate('eshopOrders.menu.addPaymentSpedition'));
		$this->setHeader('eshopOrders.menu.addPaymentSpedition','fa fa-truck');
	}

	public function actionEditPayment($id)
	{
		$payment = $this->em->getRepository(Payment::class)->find($id);

		if (!$payment)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopOrders.title.editPayment'), $payment->name);
		$this->setHeader('eshopOrders.title.editPayment', 'fa fa-credit-card');
	}
	
	public function actionEditSpedition($id)
	{
		$spedition = $this->em->getRepository(Spedition::class)->find($id);
		
		if (!$spedition)
			$this->error(null, IResponse::S404_NOT_FOUND);
		
		$this->setTitle($this->translator->translate('eshopOrders.title.editSpedition'), $spedition->name);
		$this->setHeader('eshopOrders.title.editSpedition', 'fa fa-truck');
	}
	
	public function actionEditPaymentSpedition($id)
	{
		$paymentSpedition = $this->em->getRepository(PaymentSpedition::class)->find($id);
		
		if (!$paymentSpedition)
			$this->error(null, IResponse::S404_NOT_FOUND);
		
		$this->setTitle($this->translator->translate('eshopOrders.title.editPaymentSpedition'));
		$this->setHeader('eshopOrders.title.editPaymentSpedition', 'fa fa-truck');
	}
	
	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPaymentsGrid(IPaymentsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentPaymentForm(IPaymentFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setPayment($this->getParameter('id'));
		
		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editPayment', $form->getCustomData('paymentId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentSpeditionsGrid(ISpeditionsGridFactory $factory)
	{
		return $factory->create();
	}
	
	protected function createComponentSpeditionForm(ISpeditionFormFactory $factory)
	{
		$control = $factory->create();
		
		if ($this->getParameter('id'))
			$control->setSpedition($this->getParameter('id'));
		
		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editSpedition', $form->getCustomData('speditionId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};
		
		return $control;
	}
	
	protected function createComponentPaymentSpeditionForm(IPaymentSpeditionFormFactory $factory)
	{
		$control = $factory->create();
		
		if ($this->getParameter('id'))
			$control->setPaymentSpedition($this->getParameter('id'));
		
		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editPaymentSpedition', $form->getCustomData('paymentSpeditionId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};
		
		return $control;
	}
	
	protected function createComponentPaymentSpeditionsGrid(IPaymentSpeditionsGridFactory $factory)
	{
		return $factory->create();
	}
	
}
