<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\PaymentSpedition;

/**
 * class PaymentSpeditions
 * @package EshopOrders\Model
 * 
 * @method PaymentSpedition|object|null getReference($id)
 * @method PaymentSpedition|null get($id)
 */
class PaymentSpeditions extends BaseEntityService
{
	protected $entityClass = PaymentSpedition::class;
	
	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	public function setPublish($id, $state)
	{
		if ($item = $this->getReference($id)) {
			$item->isPublished = $state;
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	public function getAll()
	{
		$paymentSpeditionsQuery = $this->getEr()->createQueryBuilder('ps', 'ps.id')
			->leftJoin('ps.payment', 'p')
			->leftJoin('ps.spedition', 's')
			->addOrderBy('s.position', 'ASC')
			->addOrderBy('p.position', 'ASC');
		$paymentSpeditions = $paymentSpeditionsQuery->getQuery()->getResult();
		
		return $paymentSpeditions;
		
	}
	
	public function getAllPublished()
	{
		$paymentSpeditionsQuery = $this->getEr()->createQueryBuilder('ps', 'ps.id')
			->andWhere('ps.isPublished = :isPublished')->setParameter('isPublished', true)
			->leftJoin('ps.payment', 'p')
			->leftJoin('ps.spedition', 's')
			->addOrderBy('s.position', 'ASC')
			->addOrderBy('p.position', 'ASC');
		$paymentSpeditions = $paymentSpeditionsQuery->getQuery()->getResult();
		
		return $paymentSpeditions;
	}
}
