<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Core\Model\Entities\Country;

/**
 * @ORM\Table("eshop_orders__order_address")
 * @ORM\Entity
 */
class OrderAddress
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="type", type="string", nullable=false)
	 * hodnoty: dodaci, fakturacni, pro postu = pobocka/balikovna, adresa obdarovaneho, a podobne
	 * od kazdeho typu muze mit objednavka maximalne jednu adresu
	 * objednavka musi mit minimalne dodaci adresu, ostatni jsou nepovinne
	 */
	protected $type;
	
	/**
	 * @var string
	 * @ORM\Column(name="first_name", type="string", length=255, nullable = false)
	 */
	protected $firstName;
	
	/**
	 * @var string
	 * @ORM\Column(name="last_name", type="string", length=255, nullable = true)
	 */
	protected $lastName;
	
	/**
	 * @var string
	 * @ORM\Column(name="email", type="string", length=255, nullable = true)
	 */
	protected $email;
	
	/**
	 * @var string
	 * @ORM\Column(name="phone", type="string", length=255, nullable = true)
	 */
	protected $phone;

	/**
	 * @var string
	 * @ORM\Column(name="company", type="string", nullable = true)
	 */
	protected $company;

	/**
	 * @var string
	 * @ORM\Column(name="street", type="string", nullable = true)
	 */
	protected $street;

	/**
	 * @var string
	 * @ORM\Column(name="city", type="string", nullable = true)
	 */
	protected $city;
	
	/**
	 * @var string
	 * @ORM\Column(name="postal", type="string", nullable = true)
	 */
	protected $postal;
	
	/**
	 * @var Country
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Country", )
	 * @ORM\JoinColumn(name="country_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $country;
	
	/** IČO
	 * @var string
	 * @ORM\Column(name="id_number", type="string", nullable = true)
	 */
	protected $idNumber;
	
	/** DIČ
	 * @var string
	 * @ORM\Column(name="vat_number", type="string", nullable = true)
	 */
	protected $vatNumber;

	/* property $order nenastavuji - kvuli Doctrine by se muselo odlisit:
	 *		- "objednavka, pro kterou je toto dodaci adresa"
	 *		- "objednavka, pro kterou je toto fakturacni adresa"
	 *		- "objednavka, pro kterou je toto adresa posty"
	 *		- ....
	 *	prestoze by byla vyplnena vzdy jen jedna z techto adres
	 */

	public function __construct($type)
	{
		$this->type		= $type;
	}
	
	public function getType()
	{
		return $this->type;
	}

	public function getFirstName()
	{
		return $this->firstName;
	}

	public function getLastName()
	{
		return $this->lastName;
	}

	public function getCompany()
	{
		return $this->company;
	}

	public function getStreet()
	{
		return $this->street;
	}

	public function getCity()
	{
		return $this->city;
	}

	public function getPostal()
	{
		return $this->postal;
	}
	
	public function setFirstName($firstName)
	{
		$this->firstName = $firstName;
		return $this;
	}
	
	public function setLastName($lastName)
	{
		$this->lastName = $lastName;
		return $this;
	}
	
	public function setCompany($company)
	{
		$this->company = $company;
		return $this;
	}
	
	public function setStreet($street)
	{
		$this->street = $street;
		return $this;
	}
	
	public function setCity($city)
	{
		$this->city = $city;
		return $this;
	}
	
	public function setPostal($postal)
	{
		$this->postal = $postal;
		return $this;
	}
	
	/*******
	 * === Email
	 */
	
	public function getEmail()
	{
		return $this->email;
	}
	
	public function setEmail($email): OrderAddress
	{
		$this->email = $email;
		return $this;
	}
	
	/*******
	 * === Phone
	 */
	
	public function getPhone()
	{
		return $this->phone;
	}
	
	public function setPhone($phone): OrderAddress
	{
		$this->phone = $phone;
		return $this;
	}
	
	/*******
	 * === Country
	 */
	
	public function getCountry()
	{
		return $this->country;
	}
	
	public function setCountry($country): OrderAddress
	{
		$this->country = $country;
		return $this;
	}
	
	/*******
	 * === IdNumber - ICO
	 */
	
	public function getIdNumber()
	{
		return $this->idNumber;
	}
	
	public function setIdNumber($idNumber): OrderAddress
	{
		$this->idNumber = $idNumber;
		return $this;
	}
	
	/*******
	 * === VatNumber - DIC
	 */
	
	public function getVatNumber()
	{
		return $this->vatNumber;
	}
	
	public function setVatNumber($vatNumber): OrderAddress
	{
		$this->vatNumber = $vatNumber;
		return $this;
	}
}
