<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Nette\Utils\DateTime;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Gedmo\Mapping\Annotation as Gedmo;
use Users\Model\Entities\User;

/**
 * @ORM\Table("eshop_orders__order_status")
 * @ORM\Entity
 */
class OrderStatus
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Order
	 * @ORM\ManyToOne(targetEntity="Order", inversedBy="orderStatuses")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $order;

	/**
	 * @var Status
	 * @ORM\ManyToOne(targetEntity="Status")
	 * @ORM\JoinColumn(name="status_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $status;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	protected $created;

	/**
	 * @var User
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="created_by", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $createdBy;

	/**
	 * @var string
	 * @ORM\Column(name="parameter", type="string", length=255, nullable=true)
	 */
	protected $parameter;

	/**
	 * @var string
	 * @ORM\Column(name="message", type="text", nullable=true)
	 */
	protected $message;

	/**
	 * @var boolean
	 * @ORM\Column(name="deleted", type="boolean", nullable=true)
	 */
	protected $deleted;

	public function __construct($order, $status, $createdBy = null)
	{
		$this->order     = $order;
		$this->status    = $status;
		$this->createdBy = $createdBy;
		$this->created   = new DateTime();
	}

	/**
	 * @return Order
	 */
	public function getOrder(): Order
	{
		return $this->order;
	}

	/**
	 * @return Status
	 */
	public function getStatus()
	{
		return $this->status;
	}

	/**
	 * @return DateTime
	 */
	public function getCreated()
	{
		return $this->created;
	}

	/**
	 * @return User
	 */
	public function getCreatedBy(): User
	{
		return $this->createdBy;
	}

	/**
	 * @return string
	 */
	public function getParameter(): string
	{
		return $this->parameter;
	}

	/**
	 * @param string $parameter
	 *
	 * @return OrderStatus
	 */
	public function setParameter(string $parameter): OrderStatus
	{
		$this->parameter = $parameter;

		return $this;
	}

	/**
	 * @return string
	 */
	public function getMessage(): ?string
	{
		return $this->message;
	}

	/**
	 * @param string $message
	 *
	 * @return OrderStatus
	 */
	public function setMessage(string $message): OrderStatus
	{
		$this->message = $message;

		return $this;
	}

	/**
	 * @return bool
	 */
	public function isDeleted()
	{
		return $this->deleted;
	}

	/**
	 * @param bool $deleted
	 *
	 * @return OrderStatus
	 */
	public function setDeleted(bool $deleted): OrderStatus
	{
		$this->deleted = $deleted;

		return $this;
	}


}

