<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Nette\SmartObject;

class BasePS
{
	use SmartObject;

	/** @var int */
	public $id;

	/** @var string */
	protected $name;

	/** @var string */
	protected $ident;

	/** @var string */
	protected $text;

	/** @var int */
	protected $isPublished;

	/** @var int */
	protected $position;

	/** @var float */
	protected $price;

	/** @var int */
	protected $freeFrom;

	/** @var int */
	protected $availableFrom;

	/** @var int */
	protected $availableTo;

	/** @var string */
	public $image;

	/** @var Cart */
	protected $cart;

	public function getId(): int { return $this->id; }

	public function setId(int $id): self
	{
		$this->id = $id;

		return $this;
	}

	public function getIdent(): ?string { return $this->ident; }

	public function setIdent($ident): self
	{
		$this->ident = $ident;

		return $this;
	}

	public function getName(): string { return $this->name; }

	public function setName(string $name): self
	{
		$this->name = $name;

		return $this;
	}

	public function getText(): ?string { return $this->text; }

	public function setText(string $text): self
	{
		$this->text = $text;

		return $this;
	}

	public function isPublished(): bool { return (bool) $this->isPublished; }

	public function setPublished($isPublished): self
	{
		$this->isPublished = $isPublished;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPrice(): float { return $this->price; }

	public function setPrice(float $price): self
	{
		$this->price = $price;

		return $this;
	}

	public function setCart(Cart &$cart): self
	{
		$this->cart = &$cart;

		return $this;
	}

	/**
	 * vrati cenu podle kosiku:
	 *  - podle celkove ceny objednavky muze byt doprava zdarma
	 *  - kdyz je v kosiku produkt se stitkem "doprava zdarma"
	 *
	 * @param Cart $cart
	 *
	 * @return float
	 */
	public function getPriceActual(?Cart $cart = null): float
	{
		$cart = $cart ?: $this->cart;

		if ($this->getFreeFrom() <= $cart->getCartItemsPrice()) {
			return 0;
		}

		foreach ($cart->getCartItems() as $item) {
			if ($item->freeDelivery === true) {
				return 0;
			}
		}

		return $this->getPrice();
	}

	public function getFreeFrom(): int { return $this->freeFrom; }

	public function setFreeFrom(int $freeFrom): self
	{
		$this->freeFrom = $freeFrom;

		return $this;
	}

	public function getAvailableFrom(): int { return $this->availableFrom; }

	public function setAvailableFrom(int $availableFrom): self
	{
		$this->availableFrom = $availableFrom;

		return $this;
	}

	public function getAvailableTo(): int { return $this->availableTo; }

	public function setAvailableTo(int $availableTo): self
	{
		$this->availableTo = $availableTo;

		return $this;
	}

	public function getImage(): ?string { return $this->image; }

	public function setImage(string $image): self
	{
		$this->image = $image;

		return $this;
	}
}
