<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Entities\OrderDiscount;
use Kdyby\Doctrine\Entities\MagicAccessors;

class Discount implements IDiscount
{
	use MagicAccessors;

	/** @var string */
	public $id;

	/** @var string */
	public $title;

	/** @var float */
	public $amount;

	/** @var float */
	public $discount;

	/** @var string */
	public $type;

	/** @var string */
	public $typeSymbol;

	public function __construct(string $id, float $amount, string $type)
	{
		$this->id     = $id;
		$this->amount = $amount;
		$this->type   = $type;
	}

	public function calculateDiscount(float $price): float
	{
		if ($this->type == OrderDiscount::TYPE_PERCENT)
			$discount = -($price * ((float) $this->amount / 100));
		else
			$discount = -((float) $this->amount);

		$this->discount = ceil($discount);

		return $this->discount;
	}

	/**
	 * @return float
	 */
	public function getValue(): float
	{
		return $this->amount;
	}

	/**
	 * @return string
	 */
	public function getType(): string
	{
		return $this->type;
	}
}



