<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Spedition;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopOrders\Model\Entities\Spedition;
use EshopOrders\AdminModule\Model\Speditions;

class SpeditionForm extends BaseControl
{
	/** @var Spedition */
	public $spedition;

	/** @var Speditions */
	protected $speditionsService;

	public function __construct(Speditions $speditions)
	{
		$this->speditionsService = $speditions;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'default.name')->setRequired()->setMaxLength(255);
		$form->addText('ident', 'eshopOrders.paymentForm.itemIdent')->setMaxLength(255);
		$form->addText('text', 'default.text')->setMaxLength(255);
		$form->addBool('isPublished', 'default.isActive')->setDefaultValue(1);
		$form->addInteger('price', 'eshopOrders.default.priceSimple');
		$form->addInteger('freeFrom', 'eshopOrders.default.freeFrom');
		$form->addInteger('availableFrom', 'eshopOrders.default.availableFrom');
		$form->addInteger('availableTo', 'eshopOrders.default.availableTo');
		$form->addFilesManager('image', 'default.image');
		$form->addText('zboziId', 'eshopOrders.speditionForm.zboziId')->setMaxLength(255);
		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->spedition) {
				$spedition    = $this->spedition;
				$flashMessage = 'eshopOrders.speditionForm.edited';
			} else {
				$spedition    = new Spedition();
				$flashMessage = 'eshopOrders.speditionForm.added';
			}

			$spedition->setName($values->name);
			$spedition->setIdent($values->ident);
			$spedition->setText($values->text);
			$spedition->isPublished = $values->isPublished;
			$spedition->setPrice((int) $values->price);
			$spedition->setFreeFrom((int) $values->freeFrom);
			$spedition->setAvailableFrom((int) $values->availableFrom);
			$spedition->setAvailableTo((int) $values->availableTo);
			$spedition->image = $values->image;
			$spedition->setZboziId($values->zboziId);

			$this->em->persist($spedition)->flush();
			$form->addCustomData('speditionId', $spedition->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setSpedition($id)
	{
		$this->spedition = $this->speditionsService->get($id);

		if ($this->spedition) {
			$m = $this->spedition;
			$this['form']->setDefaults([
				'name'          => $m->getName(),
				'ident'         => $m->getIdent(),
				'text'          => $m->getText(),
				'isPublished'   => $m->isPublished,
				'price'         => $m->getPrice(),
				'freeFrom'      => $m->getFreeFrom(),
				'availableFrom' => $m->getAvailableFrom(),
				'availableTo'   => $m->getAvailableTo(),
				'image'         => $m->image,
				'zboziId'       => $m->getZboziId(),
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
