<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__invoice_supplier")
 * @ORM\Entity
 */
class Supplier
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string|null
	 * @ORM\Column(name="name", type="string")
	 */
	public $name;

	/** IČO
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $idNumber;

	/** DIČ
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $vatNumber;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $email;

	/**
	 * @var Bank
	 * @ORM\OneToOne(targetEntity="Bank", cascade={"persist"})
	 * @ORM\JoinColumn(name="bank_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $bank;

	/**
	 * @var bool
	 * @ORM\Column(type="boolean", options={"default": false})
	 */
	public $isPayerVat = false;

	/**
	 * @var Address
	 * @ORM\OneToOne(targetEntity="Address", cascade={"persist"})
	 * @ORM\JoinColumn(name="address_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $address;

	/**
	 * Supplier constructor.
	 * @param Bank $bank
	 * @param Address $address
	 */
	public function __construct(Bank $bank, Address $address)
	{
		$this->bank = $bank;
		$this->address = $address;
	}

	/**
	 * @return Bank
	 */
	public function getBank(): Bank
	{
		return $this->bank;
	}

	/**
	 * @return Address
	 */
	public function getAddress(): Address
	{
		return $this->address;
	}


}