<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__invoice_config", uniqueConstraints={@ORM\UniqueConstraint(columns={"ident"})})
 * @ORM\Entity
 */
class InvoiceConfig
{
	use Identifier;
	use MagicAccessors;

	/** @var string */
	public const DEFAULT_CONFIG_IDENT = 'default';

	/**
	 * @var int
	 * @ORM\Column(type="string", nullable = false)
	 */
	public $ident;

	/**
	 * @var int
	 * @ORM\Column(type="integer", nullable = false)
	 */
	public $maturity;

	/**
	 * @var NumericalSeries
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"persist"})
	 * @ORM\JoinColumn(name="numerical_series_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $numericalSeries;

	/**
	 * InvoiceConfig constructor.
	 * @param string $ident
	 * @param int $maturity
	 * @param NumericalSeries $numericalSeries
	 */
	public function __construct(string $ident, int $maturity, NumericalSeries $numericalSeries)
	{
		$this->ident = $ident;
		$this->maturity = $maturity;
		$this->numericalSeries = $numericalSeries;
	}


}