<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopOrders\FrontModule\Components\Customer\IOrdersListFactory;
use EshopOrders\FrontModule\Components\Customer\IProfileFormFactory;
use EshopOrders\FrontModule\Model\Orders;
use EshopOrders\FrontModule\Model\Customers;
use Nette\Http\IResponse;
use Users\Model\Users;

class CustomerPresenter extends BasePresenter
{
	/** @var Orders */
	protected $ordersService;

	/** @var Users */
	protected $usersService;

	/** @var Customers */
	protected $customersService;

	public function __construct(Orders $orders, Users $users, Customers $customers)
	{
		$this->ordersService    = $orders;
		$this->usersService     = $users;
		$this->customersService = $customers;
	}

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'customer'))
			$this->redirect(':Users:Front:Login:');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this->template->messages     = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes = [];
	}

	public function actionOrderDetail(int $orderId)
	{
		$userId   = $this->getUser()->id;
		$customer = $this->customersService->getByUserId($userId);
		$order    = $this->ordersService->getDetail($orderId);

		if ($order['customer'] == null || $order['customer']['id'] != $customer->getId())
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->template->order = $order;
	}

	public function actionEditProfile()
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrdersList(IOrdersListFactory $factory)
	{
		$control = $factory->create();

		return $control;
	}

	protected function createComponentProfileForm(IProfileFormFactory $factory)
	{
		$control = $factory->create();
		if ($this->getUser()->id) {
			$userId              = $this->getUser()->id;
			$control->onAnchor[] = function() use ($userId, $control) {
				$user     = $this->usersService->get($userId);

				$customer = $this->customersService->getOrCreateCustomer($user, $user->getEmail(), $user->getName(), $user->getLastname());
				$control->setUser($user, $customer);
			};
		}

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('this');
		};

		return $control;
	}
}
