<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use EshopOrders\FrontModule\Model\Dao\Cart;
use Nette\Http\Session;
use Nette\Http\SessionSection;

class CartFacade
{
	const SESSION_KEY = 'eshopOrdersOrderForm';

	/** @var SessionSection */
	protected $sessionSection;

	/** @var Carts */
	protected $carts;

	/** @var Speditions */
	protected $speditions;

	/** @var Payments */
	protected $payments;

	/** @var CartHelper */
	protected $cartHelper;

	public function __construct(Session $session, Carts $carts, Speditions $speditions, Payments $payments, CartHelper $cartHelper)
	{
		$this->sessionSection = $session->getSection(self::SESSION_KEY);
		$this->carts          = $carts;
		$this->speditions     = $speditions;
		$this->payments       = $payments;
		$this->cartHelper     = $cartHelper;
	}

	public function getCart(): Cart
	{
		$cart = $this->carts->getCurrentCart();

		$formData = $this->getOrderFormData();
		if ($formData['spedition'] && $v = $this->speditions->get($formData['spedition']))
			$cart->setSpedition($v);
		if ($formData['payment'] && $v = $this->payments->get($formData['payment']))
			$cart->setPayment($v);

		return $cart;
	}

	public function getCartsService(): Carts { return $this->carts; }

	public function getOrderFormData(): array { return $this->sessionSection->orderFormData ?: []; }

	public function countFreeSpedition(): ?array { return $this->cartHelper->countFreeSpedition(); }
}
