<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\Model\Entities\OrderFlag;
use Nette\Http\Session;
use Heureka\ShopCertification;
use Tracy\Debugger;

class OrderHeurekaSubscriber implements EventSubscriber
{
	/** @var  array */
	protected $heurekaConf;

	/** @var SessionSection */
	protected $orderSuccessMessages;

	public function __construct(array $data, Session $session)
	{
		$this->heurekaConf          = $data['heurekaConfig'];
		$this->orderSuccessMessages = $session->getSection('eshopOrders/orderSuccessMessages');
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 101],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		try {
			$conf  = $this->heurekaConf;
			$order = $event->order;
			if (!$order->hasFlag(OrderFlag::TYPE_QUESTIONING) || !$conf['privateKey'])
				return;
			
			$shopCertification = new ShopCertification($conf['privateKey']);
			
			$shopCertification->setEmail($order->getAddressDelivery()->getEmail());
			$shopCertification->setOrderId($order->getId());
			
			
			foreach ($order->getOrderItems() as $orderItem) {
				$shopCertification->addProductItemId($orderItem->getProductId());
			}
			
			$shopCertification->logOrder();
		} catch (\Exception $e) {
			Debugger::log("Failed export conversion on Heureka: orderId='{$order->getId()}' ({$e->getFile()}: {$e->getLine()}) - {$e->getMessage()}", 'eshopordersConversion');
		}
	}
}
