import {scrollTo} from 'core/js/utils/utilities';
import {slideDown, slideUp} from "es6-slide-up-down";

let oldValidateControl = Nette.validateControl;
let oldValidateForm = Nette.validateForm;
let lastError = false;
let actualStep = 1;
let validatedSteps = {
	1: true,
	2: false,
	3: false,
	4: false,
};

const showStep = (step) => {
	actualStep = step;
	validatedSteps[step] = true;
	step = step.toString();
	document.querySelectorAll('[data-visible-step]').forEach((el) => {
		if (el.dataset.visibleStep.split(',').includes(step) === true)
			el.style.display = 'block';
		else
			el.style.display = 'none';
	});

	document.querySelectorAll('[data-cart-step]').forEach((el) => {
		let parent = el.parentElement;
		if (el.dataset.cartStep == step)
			parent.classList.add('active');
		else
			parent.classList.remove('active');
	});
};

const addValidStep = (step) => {
	step = step.toString();
	validatedSteps[step] = true;

	updateValidSteps();
};

const removeValidStep = (step) => {
	validatedSteps[step] = false;

	while (step <= 4) {
		validatedSteps[step] = false;
		step++;
	}

	updateValidSteps();
};

const updateValidSteps = () => {
	let lastStatus = true;
	for (let i = 1; i <= 4; i++) {
		let el = document.querySelector('[data-cart-step="' + i + '"]');
		let parent = el.parentElement;

		if (validatedSteps[i] === true || parseInt(actualStep) === i) {
			parent.classList.remove('invalid');
		} else {
			parent.classList.add('invalid');
		}
	}
};

const getCurrentStepFromInput = (input) => {
	let i = 0;
	let parent = input;

	while (parent && parent.dataset.visibleStep === undefined && i < 25) {
		parent = parent.parentElement;
		i++;
	}

	return parent.dataset && parent.dataset.visibleStep !== undefined ? parent.dataset.visibleStep : null;
};

const getCurrentStepFromNav = () => {
	return parseInt(document.querySelector('[data-cart-steps] .active [data-cart-step]').dataset.cartStep);
};

const showError = (elem) => {
	lastError = elem;
	let step = getCurrentStepFromInput(elem);
	let firstError = document.querySelector('[data-visible-step="' + step + '"] .has-error');
	scrollTo(firstError.offsetTop);
};

Nette.validateControl = (elem, rules, onlyCheck, value, emptyOptional) => {
	let result = oldValidateControl(elem, rules, onlyCheck, value, emptyOptional);

	// UI vizualizace chyby dopravy a platby
	if (['spedition', 'payment'].includes(elem.name)) {
		let box = elem.parentElement.parentElement.parentElement;
		if (elem.classList.contains('has-error'))
			box.classList.add('has-error');
		else
			box.classList.remove('has-error');
	}

	if (!result && !lastError) {
		showError(elem);
	}

	return result;
};

document.addEventListener('DOMContentLoaded', () => {
	// Krokovani stránek
	showStep(actualStep);
	console.log(global.naja);

	// Zaškrtnutí/odškrtnutí dopravy a platby
	let speditions = document.querySelectorAll('input[id^="frm-orderForm-form-spedition_"]');
	let payments = document.querySelectorAll('input[id^="frm-orderForm-form-payment_"]');
	let obj = {'sped': speditions, 'pay': payments};
	for (let key in obj) {
		let list = obj[key];
		let secondLlist = key == 'sped' ? payments : speditions;
		list.forEach(function (el) {
			el.addEventListener('click', (e) => {
				let a = e.target;
				if (a.dataset.lastStatus == 'true') {
					list.forEach((v) => {
						v.checked = false;
						v.dataset.lastStatus = false;
					});

					secondLlist.forEach((v) => {
						v.parentElement.parentElement.classList.remove('disabled');
					});
				} else {
					let ids = a.dataset.allowed.split(',');
					a.dataset.lastStatus = a.checked;

					list.forEach((v) => {
						if (v.id == a.id)
							return true;
						v.dataset.lastStatus = false;
					});

					secondLlist.forEach((v) => {
						let parent = v.parentElement.parentElement;
						if (!ids.includes(v.value))
							parent.classList.add('disabled');
						else
							parent.classList.remove('disabled');
					});
				}
			});

			if (el.checked) {
				el.click();
			}
		});
	}

	initCartItemRemove();
	initStepButtons();
	initFreeDeliveryBar();
	checkCollapse();
	global.naja.addEventListener('success', (e) => {
		// Validace orderForm na serveru
		if (e.response.orderFormErrors !== undefined) {
			const errs = e.response.orderFormErrors;
			let firstError = null;

			for (let key in errs) {
				let el = document.getElementById(key);

				if (firstError === null)
					firstError = el;

				errs[key].forEach((e) => {
					Nette.addError(el, e);
				})
			}

			showError(firstError);
		} else if (e.response.orderFormIsValid == true) {
			const currentStep = getCurrentStepFromNav();

			showStep(currentStep + 1);
			addValidStep(currentStep);
			scrollTo(0, 300);
		}
	});
	global.naja.addEventListener('complete', (e) => {
		initCartItemRemove();
		initStepButtons();
		initFreeDeliveryBar();
		checkCollapse();
	});

	// Přesměrování na platební bránu
	const paymentGatewayWrap = document.querySelector('[data-payment-gateway-wrap]');
	if (paymentGatewayWrap) {
		setTimeout(function () {
			document.querySelector('[data-payment-gateway-btn]').click();
		}, 3000);
	}
});

// Free delivery bar
let initPercent = 0;
const initFreeDeliveryBar = () => {
	let freeDelivery = document.querySelector('[data-free-delivery-bar-wrap]');
	let freeDeliveryProgress = document.querySelector('[data-free-delivery-progress]');
	let newPercent = 0;

	if (freeDeliveryProgress) {
		freeDeliveryProgress.style.width = initPercent + '%';
		setTimeout(function () {
			initPercent = parseFloat(freeDelivery.dataset.percent);
			freeDeliveryProgress.style.width = initPercent + '%';
		}, initPercent === 0 ? 1000 : 250);
	} else if (freeDelivery) {
		initPercent = parseFloat(freeDelivery.dataset.percent);
	}
};

// Tlačítka na stránky
const initStepButtons = () => {
	document.querySelectorAll('a[data-cart-go-to]:not(.init), a[data-cart-step]:not(.init)').forEach((el) => {
		el.classList.add('init');
		el.addEventListener('click', (e) => {
			e.stopImmediatePropagation();
			let step = el.dataset.cartGoTo !== undefined ? el.dataset.cartGoTo : el.dataset.cartStep;
			showStep(step);
			updateValidSteps();
			scrollTo(0);
		});
	});
};

// Odstranění z košíku
const initCartItemRemove = () => {
	console.log(document.querySelectorAll('[data-remove-item]:not(.init)'));
	for (let el of document.querySelectorAll('[data-remove-item]:not(.init)')) {
		el.classList.add('init');
		el.addEventListener('click', function () {
			let input = document.querySelector('input[data-item-id="' + el.dataset.item + '"]');

			input.value = 0;
			input.dispatchEvent(new Event('change'));
		});
	}
};

const checkCollapse = () => {
	// Kliknutí na data-collapse
	document.querySelectorAll('[data-collapse]:not(.init)').forEach((el) => {
		el.classList.add('init');
		el.addEventListener('click', () => {
			el.classList.toggle('active');

			let target = document.getElementById(el.dataset.collapse);
			if (target) {
				if (window.getComputedStyle(target).display === 'none')
					slideDown(target);
				else
					slideUp(target);
			}
		});
	});

	// Změna data-check-collapse
	document.querySelectorAll('[data-check-collapse]:not(.init)').forEach((el) => {
		el.classList.add('init');
		el.addEventListener('change', (e) => {
			let target = document.getElementById(el.dataset.checkCollapse);
			if (target) {
				if (window.getComputedStyle(target).display === 'none')
					slideDown(target);
				else
					slideUp(target);
			}
		});
	});
}
