<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class CartItemGift
{
	/** @var int */
	protected $productId;

	/** @var Product */
	protected $product;

	/** @var string */
	public $code1;

	/** @var string */
	public $ean;

	/** @var string */
	protected $name;

	public function __construct(Product $product, ?string $name = null)
	{
		$this->product   = $product;
		$this->productId = $product->getId();
		$this->name      = $name ?: $product->getName();
		$this->code1     = $product->getCode1();
		$this->ean       = $product->getEan();
	}

	public function getProductId(): int { return $this->productId; }

	public function getName(): string { return $this->name; }
}
