<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Status;

/**
 * class Statuses
 * @package EshopOrders\Model
 *
 * @method Status|object|null getReference($id)
 * @method Status|null get($id)
 */
class Statuses extends BaseEntityService
{
	protected $entityClass = Status::class;
	
	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	public function getAll() {
		return $this->getEr()->findBy(array(), array('position' => 'ASC'));
	}
	
}
