<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__invoice_bank")
 * @ORM\Entity
 */
class Bank
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $iban;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $swift;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $variableSymbol;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $bankCode;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable = true)
	 */
	public $bankAccount;

}