<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/** podobne jako order_item, ale samostatna tabulka
 * @ORM\Table("eshop_orders__order_spedition")
 * @ORM\Entity
 */
class OrderSpedition
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Spedition
	 * @ORM\ManyToOne(targetEntity="Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $spedition;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $name;

	/**
	 * @var float
	 * @ORM\Column(name="price", type="decimal", precision=10, scale=2)
	 */
	protected $price;

	/**
	 * @var Order
	 * @ORM\OneToOne(targetEntity="Order", inversedBy="spedition")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;

	public function __construct(Spedition $spedition, Order $order)
	{
		$this->spedition = $spedition;
		$this->name      = $spedition->getName();
		$this->price     = $spedition->getPrice();
		$this->order     = $order;
	}

	public function getSpedition(): ?Spedition { return $this->spedition; }

	public function setSpedition(Spedition $spedition): self
	{
		$this->spedition = $spedition;

		return $this;
	}

	public function getName(): string { return $this->name; }

	public function setName(string $name): self
	{
		$this->name = $name;

		return $this;
	}

	public function getPrice(): float { return (float) $this->price; }

	public function setPrice(float $price): self
	{
		$this->price = $price;

		return $this;
	}

	public function getOrder(): Order { return $this->order; }

	public function getPickupTypeTitle(): ?string
	{
		if ($this->getSpedition() && in_array($this->getSpedition()->getIdent(), ['zasilkovna', 'ulozenka', 'dpdPickup', 'balikomat']))
			return $this->getName();

		return null;
	}
}
