<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;

class OrdersCount extends Widget implements IWidget
{
	protected $gridSize = 'col-md-4 col-xxl-3';

	protected $key = 'eshopOrdersOrdersCount';

	/** @var Statistics\Overview @inject */
	public $overview;

	public function render()
	{
		$this->template->key   = $this->key;
		$this->template->icon  = 'fas fa-shopping-cart';
		$this->template->title = $this->t('eshopOrders.dashboardWidget.ordersCount.title');

		$data = $this->overview->getOrdersCount();
		$this->template->value = number_format($data['count'], 0, '', ' ');
		$this->template->percent = $data['percent'];

		$this->template->baseTemplate = __DIR__ . '/baseCount.latte';
		$this->template->render($this->getTemplateFile());
	}
}
