<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\FrontModule\Model\CardsPaymentService;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderAddress;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Payments;
use EshopOrders\AdminModule\Model\Speditions;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class OrderForm extends BaseControl
{
	/** @var Order */
	public $order;

	/** @var Orders */
	protected $ordersService;

	/** @var CardsPaymentService */
	protected $cardPaymentService;

	/** @var Speditions */
	private $speditionsService;

	/** @var Payments */
	private $paymentsService;

	/** @var IOrderItemsGridFactory */
	protected $orderItemsGridFactory;

	/** @var IOrderStatusesGridFactory */
	protected $orderStatusesGridFactory;

	public function __construct(
		Orders $orders,
		Speditions $speditions,
		Payments $payments,
		CardsPaymentService $cardsPaymentService,
		IOrderItemsGridFactory $orderItemsGridFactory,
		IOrderStatusesGridFactory $orderStatusesGridFactory)
	{
		$this->ordersService            = $orders;
		$this->speditionsService        = $speditions;
		$this->paymentsService          = $payments;
		$this->cardPaymentService       = $cardsPaymentService;
		$this->orderItemsGridFactory    = $orderItemsGridFactory;
		$this->orderStatusesGridFactory = $orderStatusesGridFactory;
	}

	public function render()
	{
		$this->template->order    = $this->order;
		$this->template->showPaid = EshopOrdersConfig::load('ordersGrid.showCardHistory') && (
				EshopOrdersConfig::load('showPaidFieldForAllOrders', false) === true
				|| $this->order->getPayment()->getPayment()->getIdent() === 'card');

		if (EshopOrdersConfig::load('ordersGrid.showCardHistory') && $this->order->getPayment()->getPayment()->getIdent() == 'card')
			$this->template->paymentHistory = $this->cardPaymentService->getHistoryOfOrder($this->order->getId());

		$this->template->render($this->getTemplateFile());
	}

	public function setOrder($id)
	{
		$this->order = $this->ordersService->get($id);

		if (!$this->order) {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderItemsGrid()
	{
		$control = $this->orderItemsGridFactory->create($this->order->getId());

		return $control;
	}

	protected function createComponentOrderStatusesGrid()
	{
		$control = $this->orderStatusesGridFactory->create();
		if ($this->order) {
			$control->setOrder($this->order->getId());
		}

		return $control;
	}
}
