<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderAddress;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Entities\OrderPayment;
use EshopOrders\Model\Entities\OrderSpedition;
use Symfony\Component\EventDispatcher\Event;

class OrderEvent extends Event
{
	/** @var Order */
	public $order;

	/** @var OrderAddress */
	public $addrDelivery;

	/** @var OrderAddress */
	public $addrInvoice;

	/** @var OrderSpedition */
	public $orderSpedition;

	/** @var OrderPayment */
	public $orderPayment;

	/** @var OrderItem[] */
	public $orderItems = [];

	/** @var array */
	public $formData = [];

	public function __construct(Order $order)
	{
		$this->order = $order;
	}
}
