<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopOrders\FrontModule\Components\Order\IOrderTrackingFactory;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Statuses;

class PaymentPresenter extends BasePresenter
{
	/** @var Orders */
	protected $ordersService;

	/** @var Statuses */
	protected $statusesService;

	public function __construct(Orders $orders, Statuses $statuses)
	{
		$this->ordersService   = $orders;
		$this->statusesService = $statuses;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function renderPaymentFinished()
	{
		if ($this->getParameter('orderIdent')) {
			/** @var Order $order */
			$order                 = $this->ordersService->getByIdent($this->getParameter('orderIdent'));
			$this->template->order = $order;
		}

		//flash zpravy zobrazime v textu, ne jako prekryvne
		$this->template->messages     = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderTracking(IOrderTrackingFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('orderIdent')) {
			$control->setOrder($this->getParameter('orderIdent'));
		}

		return $control;
	}
}
