<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__invoice_spedition")
 * @ORM\Entity
 */
class Spedition
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(type="string")
	 */
	public $name;

	/**
	 * @var float
	 * @ORM\Column(type="decimal", precision=10, scale=2)
	 */
	public $price;

}