<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use EshopOrders\FrontModule\Model\Dao;
use EshopOrders\Model\Entities\Cart;
use Symfony\Component\EventDispatcher\Event;

class FillDaoEvent extends Event
{
	/** @var Dao\Cart */
	public $cart;

	/** @var Cart */
	public $rawCart;

	public function __construct(Dao\Cart $cart, Cart $rawCart)
	{
		$this->cart    = $cart;
		$this->rawCart = $rawCart;
	}
}
