<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\Query;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Entities\OrderItemTexts;

class Orders extends BaseFrontEntityService
{
	/** @var string */
	public $entityClass = Order::class;

	/** @var ProductsFacade */
	protected $productsFacade;

	public function __construct(ProductsFacade $products)
	{
		$this->productsFacade = $products;
	}

	public function getDetail(int $id)
	{
		$order = $this->getEr()->createQueryBuilder('o')
			->addSelect('c, pay, sped, disc, del, inv, oStat, stat')
			->innerJoin('o.customer', 'c')
			->innerJoin('o.payment', 'pay')
			->innerJoin('o.spedition', 'sped')
			->leftJoin('o.orderDiscounts', 'disc')
			->leftJoin('o.addressInvoice', 'inv')
			->leftJoin('o.addressDelivery', 'del')
			->innerJoin('o.orderStatuses', 'oStat')
			->innerJoin('oStat.status', 'stat')
			->where('o.id = :id')->setParameter('id', $id)
			->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);

		if (!$order)
			return null;

		$orderItems  = [];
		$productsIds = [];
		foreach ($this->em->getRepository(OrderItem::class)->createQueryBuilder('oi')
			         ->addSelect('IDENTITY(oi.product) as productId, itemsTxt')
			         ->where('oi.order = :order')
			         ->leftJoin('oi.orderItemTexts', 'itemsTxt')
			         ->setParameters([
				         'order' => $order['id'],
			         ])
			         ->getQuery()->getArrayResult() as $row) {
			$row += $row[0];
			unset($row[0]);

			$row['text'] = $row['orderItemTexts'][$this->translator->getLocale()] ?? array_values($row['orderItemTexts'])[0];
			unset($row['orderItemTexts']);

			$orderItems[$row['id']] = $row;
			$productsIds[]          = $row['productId'];
		}

		$products = $this->productsFacade->getProducts($productsIds);
		foreach ($orderItems as $k => $v)
			$orderItems[$k]['product'] = $products[$v['productId']];
		unset($products);

		if (!$order['addressDelivery'])
			$order['addressDelivery'] = $order['addressInvoice'];

		$order['orderItems'] = $orderItems;

		$itemsPrice = 0;
		foreach ($order['orderItems'] as $k => &$v) {
			$itemsPrice += (float) round($v['price'] * $v['quantity'], 2);
		}

		$order['itemsPrice']                = $itemsPrice;
		$order['totalPriceWithoutDiscount'] = $itemsPrice + (float) $order['spedition']['price'] + (float) $order['payment']['price'];

		return $order;
	}
}
