<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopOrders\FrontModule\Model\CardsPaymentService;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Statuses;

class FinishedPresenter extends BasePresenter
{
	/** @persistent */
	public $orderIdent;

	/** @var Orders */
	protected $ordersService;

	/** @var Statuses */
	protected $statusesService;

	/** @var Order */
	public $order;

	/** @var CardsPaymentService */
	protected $cardsPaymentService;

	public function __construct(Orders $orders, Statuses $statuses, CardsPaymentService $cardsPaymentService)
	{
		$this->ordersService         = $orders;
		$this->statusesService       = $statuses;
		$this->cardsPaymentService   = $cardsPaymentService;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionOrderFinished()
	{
		if ($this->getParameter('orderIdent')) {
			$this->order = $this->ordersService->getByIdent($this->getParameter('orderIdent'));
		}
	}

	/*******************************************************************************************************************
	 * ============================== Renders
	 */

	public function renderOrderFinished()
	{
		if ($this->order) {
			$this->template->order = $this->order;
		}

		//flash zpravy zobrazime v textu, ne jako prekryvne
		$paymentType                      = $this->order ? $this->order->getPayment()->getPayment()->getIdent() : null;
		$this->template->paymentType      = $paymentType;
		$this->template->messages         = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes     = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	/*******************************************************************************************************************
	 * ============================== Other
	 */
}
