<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Customer;

use Core\Model\Countries;
use Core\Model\UI\Form\BaseForm;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Core\Model\UI\BaseControl;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\CustomerAddress;
use Users\Model\Entities\User;

class ProfileForm extends BaseControl
{
	/** @var User */
	public $user;

	/** @var Customer */
	public $customer;

	/** @var Countries */
	protected $countriesService;

	public function __construct(Countries $countries)
	{
		$this->countriesService = $countries;
	}


	public function render()
	{
		if (!$this->user)
			return '';

		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addText('name', 'default.name');
		$form->addText('lastname', 'default.lastName')->setRequired();
		$form->addPassword('password', 'default.password');
		$form->addEmail('email', 'default.email')->setRequired();
		$form->addText('phone', 'default.phone');

		$countries = $this->countriesService->getAllNameColumn();

		$addressDelivery = $form->addContainer('addressDelivery');
		$addressInvoice  = $form->addContainer('addressInvoice');

		foreach (['firstName', 'lastName', 'email', 'phone', 'company', 'street', 'city', 'postal', 'idNumber', 'vatNumber', 'country'] as $v) {
			foreach (['addressDelivery', 'addressInvoice'] as $com)
				if ($v == 'email')
					${$com}->addEmail($v, 'eshopOrders.default.' . $v)
						->setMaxLength(255);
				else if ($v == 'country')
					${$com}->addSelect($v, 'eshopOrders.default.' . $v, $countries);
				else
					${$com}->addText($v, 'eshopOrders.default.' . $v)
						->setMaxLength(255);
		}

		$form->addSubmit('submit', 'default.save');
		$form->addCancel('cancel', 'default.cancel');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		if ($form->isSubmitted()->getName() === 'cancel') {
			$this->getPresenter()->redirect(':EshopOrders:Front:Customer:');
		}

		try {
			$user     = $this->user;
			$customer = $this->customer;

			$user->setName($values->name);
			$user->setLastname($values->lastname);
			$user->setEmail($values->email);
			$customer->setPhone($values->phone);

			$addressDelivery = $customer->getAddressDelivery() ?: new CustomerAddress($customer);
			$addressInvoince = $customer->getAddressInvoice() ?: new CustomerAddress($customer);

			$customer->setAddressDelivery($addressDelivery);
			$customer->setAddressInvoice($addressInvoince);

			foreach (['firstName', 'lastName', 'email', 'phone', 'company', 'street', 'city', 'postal', 'idNumber', 'vatNumber', 'country'] as $v) {
				foreach (['addressDelivery', 'addressInvoice'] as $com) {
					try {
						if ($v == 'country') {
							if ($values->$com->$v)
								$customer->$com->$v = $this->countries->getReference($values->$com->$v);
						} else {
							$customer->$com->$v = $values->$com->$v;
						}
					} catch (\Exception $e) {
					}
				}
			}

			$this->em->persist($addressDelivery);
			$this->em->persist($addressInvoince);

			if ($values->password != '')
				$user->setPassword($values->password);

			$this->em->persist($user);
			$this->em->persist($customer);
			$this->em->flush();
			$this->getPresenter()->flashMessageSuccess('users.profileForm.profileUpdated');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}

		return true;
	}

	public function setUser($user, $customer)
	{
		$this->user     = $user;
		$this->customer = $customer;

		if ($this->user && $this->customer) {
			$d = [
				'name'     => $this->user->getName(),
				'lastname' => $this->user->getLastname(),
				'email'    => $this->user->getEmail(),
				'phone'    => $this->customer->getPhone(),
			];

			foreach (['firstName', 'lastName', 'email', 'phone', 'company', 'street', 'city', 'postal', 'idNumber', 'vatNumber', 'country'] as $v) {
				foreach (['addressDelivery', 'addressInvoice'] as $com) {
					if (!$customer->$com)
						continue;

					try {
						if ($v == 'country') {
							$d[$com][$v] = $customer->$com->$v ? $customer->$com->$v->getId() : null;
						} else {
							$d[$com][$v] = $customer->$com->$v;
						}
					} catch (\Exception $e) {
					}
				}
			}

			$this['form']->setDefaults($d);

			$this['form']['password']->setRequired(false);
		} else {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}
}

